/*
 * Decompiled with CFR 0.152.
 */
package me.angel.challenges6t4.challenge.challenges;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import me.angel.challenges6t4.challenge.Challenge;
import me.angel.challenges6t4.challenge.ChallengeSettings;
import net.minecraft.class_1282;
import net.minecraft.class_1657;
import net.minecraft.class_243;
import net.minecraft.class_2561;

public class SuperKnockbackChallenge
extends Challenge {
    private static final float DEFAULT_KNOCKBACK_MULTIPLIER = 3.0f;
    private static final float BASE_KNOCKBACK_VELOCITY = 0.4f;
    private static final String SETTING_KNOCKBACK_MULTIPLIER = "knockback_multiplier";
    private static final boolean DEFAULT_COOLDOWN_ENABLED = false;
    private static final int DEFAULT_COOLDOWN_SECONDS = 5;
    private static final String SETTING_COOLDOWN_ENABLED = "cooldown_enabled";
    private static final String SETTING_COOLDOWN_SECONDS = "cooldown_seconds";
    public static final float MIN_MULTIPLIER = 1.0f;
    public static final float MAX_MULTIPLIER = 25.0f;
    public static final int MIN_COOLDOWN_SECONDS = 1;
    public static final int MAX_COOLDOWN_SECONDS = 30;
    private final Map<UUID, Long> lastKnockbackTimes = new HashMap<UUID, Long>();

    public SuperKnockbackChallenge() {
        super("super_knockback", (class_2561)class_2561.method_43471((String)"challenges6t4.challenge.super_knockback.name"), (class_2561)class_2561.method_43471((String)"challenges6t4.challenge.super_knockback.description"), true, Challenge.MultiplayerStatus.UNTESTED_MULTIPLAYER);
        if (!ChallengeSettings.hasOption(this.getId(), SETTING_KNOCKBACK_MULTIPLIER)) {
            this.setKnockbackMultiplier(3.0f);
        }
        if (!ChallengeSettings.hasOption(this.getId(), SETTING_COOLDOWN_ENABLED)) {
            this.setCooldownEnabled(false);
        }
        if (!ChallengeSettings.hasOption(this.getId(), SETTING_COOLDOWN_SECONDS)) {
            this.setCooldownSeconds(5);
        }
    }

    @Override
    public boolean isGameBeatable() {
        return true;
    }

    @Override
    public void onEnable() {
    }

    @Override
    public void onDisable() {
        this.lastKnockbackTimes.clear();
    }

    public float getKnockbackMultiplier() {
        return (float)ChallengeSettings.getIntOption(this.getId(), SETTING_KNOCKBACK_MULTIPLIER, 30) / 10.0f;
    }

    public void setKnockbackMultiplier(float multiplier) {
        ChallengeSettings.setIntOption(this.getId(), SETTING_KNOCKBACK_MULTIPLIER, (int)(multiplier * 10.0f));
    }

    public boolean isCooldownEnabled() {
        return ChallengeSettings.getBooleanOption(this.getId(), SETTING_COOLDOWN_ENABLED, false);
    }

    public void setCooldownEnabled(boolean enabled) {
        ChallengeSettings.setBooleanOption(this.getId(), SETTING_COOLDOWN_ENABLED, enabled);
    }

    public int getCooldownSeconds() {
        return ChallengeSettings.getIntOption(this.getId(), SETTING_COOLDOWN_SECONDS, 5);
    }

    public void setCooldownSeconds(int seconds) {
        ChallengeSettings.setIntOption(this.getId(), SETTING_COOLDOWN_SECONDS, seconds);
    }

    public void onPlayerDamage(class_1657 player, class_1282 source, float amount) {
        if (!this.isEnabled() || player.method_37908().field_9236) {
            return;
        }
        if (this.isCooldownEnabled()) {
            long currentTime = System.currentTimeMillis();
            Long lastKnockbackTime = this.lastKnockbackTimes.get(player.method_5667());
            if (lastKnockbackTime != null) {
                long cooldownMs = (long)this.getCooldownSeconds() * 1000L;
                if (currentTime - lastKnockbackTime < cooldownMs) {
                    return;
                }
            }
        }
        float multiplier = this.getKnockbackMultiplier();
        class_243 knockbackDirection = this.calculateKnockbackDirection(player, source);
        if (knockbackDirection != null) {
            float totalKnockbackVelocity = 0.4f * multiplier;
            class_243 enhancedKnockback = knockbackDirection.method_1021((double)totalKnockbackVelocity);
            player.method_5762(enhancedKnockback.field_1352, enhancedKnockback.field_1351, enhancedKnockback.field_1350);
            player.field_6037 = true;
            if (this.isCooldownEnabled()) {
                this.lastKnockbackTimes.put(player.method_5667(), System.currentTimeMillis());
            }
        } else {
            float totalKnockbackVelocity = 0.4f * multiplier;
            double horizontalAngle = player.method_37908().method_8409().method_43058() * 2.0 * Math.PI;
            double verticalAngle = player.method_37908().method_8409().method_43058() * Math.PI;
            double x = Math.sin(verticalAngle) * Math.cos(horizontalAngle);
            double y = Math.cos(verticalAngle);
            double z = Math.sin(verticalAngle) * Math.sin(horizontalAngle);
            class_243 randomDirection = new class_243(x, y, z).method_1029();
            class_243 fallbackKnockback = randomDirection.method_1021((double)totalKnockbackVelocity);
            player.method_5762(fallbackKnockback.field_1352, fallbackKnockback.field_1351, fallbackKnockback.field_1350);
            player.field_6037 = true;
            if (this.isCooldownEnabled()) {
                this.lastKnockbackTimes.put(player.method_5667(), System.currentTimeMillis());
            }
        }
    }

    private class_243 calculateKnockbackDirection(class_1657 player, class_1282 source) {
        if (source.method_5529() != null) {
            class_243 attackerPos = source.method_5529().method_19538();
            class_243 playerPos = player.method_19538();
            return playerPos.method_1020(attackerPos).method_1029();
        }
        if (source.method_5510() != null) {
            class_243 sourcePos = source.method_5510();
            class_243 playerPos = player.method_19538();
            return playerPos.method_1020(sourcePos).method_1029();
        }
        double horizontalAngle = player.method_37908().method_8409().method_43058() * 2.0 * Math.PI;
        double verticalAngle = player.method_37908().method_8409().method_43058() * Math.PI;
        double x = Math.sin(verticalAngle) * Math.cos(horizontalAngle);
        double y = Math.cos(verticalAngle);
        double z = Math.sin(verticalAngle) * Math.sin(horizontalAngle);
        return new class_243(x, y, z).method_1029();
    }
}

